//
//  OPUserMessage.h
//  ApplicationFrameworks
//
//  Created by Kevin Hayes on 2015-02-17.
//
//

#import <Foundation/Foundation.h>
#import "OnePasswordCoreConstants.h"

// kevin 20150227
//	- these are the keys to use when creating json dictionary to init an OPUserMessage
//	- If you want a message published on an exact date, or want to sort messages chronologically, use OPUserMessagePublishDateKey
//  - If you don't want a message published after a certain date, set its OPUserMessageExpirationDateKey
//	- If you want a message published n seconds after the app first loads the message, use OPUserMessagePublishIntervalKey
//	- If both are present OPUserMessagePublishDateKey will override OPUserMessagePublishIntervalKey
//	- All values are strings
//	- MessageId should be unique


NSSTRING_CONST_EXTERN(OPUserMessageTitleKey);
NSSTRING_CONST_EXTERN(OPUserMessagePublishDateKey);
NSSTRING_CONST_EXTERN(OPUserMessageExpirationDateKey);
NSSTRING_CONST_EXTERN(OPUserMessagePublishIntervalKey);
NSSTRING_CONST_EXTERN(OPUserMessageIdKey);
NSSTRING_CONST_EXTERN(OPUserMessageBodyKey);
NSSTRING_CONST_EXTERN(OPUserMessageBodyTypeKey);
NSSTRING_CONST_EXTERN(OPUserMessageBaseURLKey);
NSSTRING_CONST_EXTERN(OPUserMessageNeedsConfettiKey);

typedef NS_ENUM(NSUInteger, OPUserMessageReadStatus) {
    OPUserMessageReadStatusUnread = 0,
    OPUserMessageReadStatusRead,
};

typedef NS_ENUM(NSUInteger, OPUserMessageBodyType) {
	OPUserMessageBodyTypePlainText = 0,
	OPUserMessageBodyTypeMarkdown,
	OPUserMessageBodyTypeHTML,
};

@interface OPUserMessage : NSObject

@property (nonatomic, strong, readonly) NSString *messageId;
@property (nonatomic, strong) NSString *title;
@property (nonatomic, strong) NSString *body;
@property (nonatomic) OPUserMessageBodyType bodyType;
@property (nonatomic, strong) NSDate *publishDate;
@property (nonatomic, strong) NSDate *expirationDate;
@property (nonatomic, strong, readonly) NSURL *baseURL;
@property (nonatomic, readonly) BOOL needsConfetti;

@property (nonatomic) OPUserMessageReadStatus readStatus;

- (instancetype)initWithDictionary:(NSDictionary *)dictionary baseURL:(NSURL *)baseURL;
- (BOOL)isEqualToUserMessage:(OPUserMessage *)userMessage;
@end
